<section class="konten mt-2">
  <div class="container-fluid">
    <div class="card border-primary">
      <div class="card-header bg-success text-white">
        <?= $title; ?>
        <a href="<?= base_url('transaksi/tambah'); ?>" class="btn btn-light btn-sm float-right">Tambah Transaksi</a>
      </div>

      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-bordered table-striped">
            <thead>
              <tr>
                <th>No</th>
                <th>ID Transaksi</th>
                <th>ID Pelanggan</th>
                <th>ID Paket Laundry</th>
                <th>Berat (KG)</th>
                <th>Total Harga</th>
                <th>Tanggal</th>
                <th>Status</th>
                <th>Aksi</th>
              </tr>
            </thead>

            <tbody>
              <?php $no = 1; foreach($transaksi as $t): ?>
              <tr>
                <td><?= $no++; ?></td>
                <td><?= $t['id_transaksi']; ?></td>
                <td><?= $t['id_pelanggan']; ?></td>
                <td><?= $t['id_paket']; ?></td>
                <td><?= $t['berat_kg']; ?> KG</td>
                <td>Rp <?= number_format($t['total_harga'], 0, ',', '.'); ?></td>
                <td><?= $t['tanggal']; ?></td>
                <td>
                  <?php if($t['status'] == 'Proses'): ?>
                    <span class="badge bg-warning text-dark">Proses</span>
                  <?php elseif($t['status'] == 'Selesai'): ?>
                    <span class="badge bg-success">Selesai</span>
                  <?php else: ?>
                    <span class="badge bg-primary">Diambil</span>
                  <?php endif; ?>
                </td>

                <td>
                  <a href="<?= base_url('transaksi/edit/'.$t['id_pelanggan']); ?>" 
                     class="btn btn-success btn-sm">Edit</a>

                  <a href="<?= base_url('transaksi/hapus/'.$t['id_pelanggan']); ?>" 
                     onclick="return confirm('Yakin ingin hapus transaksi ini?')" 
                     class="btn btn-danger btn-sm">Hapus</a>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>

          </table>
        </div>
      </div>

    </div>
  </div>
</section>
