<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class pengeluaran extends CI_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('M_pengeluaran');
	}

	public function index()
	{
		$data['title']= 'Manajemen Data pengeluaran';
		$data['pengeluaran']= $this->M_pengeluaran->tampil_data()->result_array();

		$this->load->view('v_header',$data);
		$this->load->view('pengeluaran/v_data_pengeluaran', $data);
		$this->load->view('v_footer');
	}
	
	function tambah(){
		$data['title']= 'Tambah Data pengeluaran';

		$this->load->view('v_header',$data);
		$this->load->view('pengeluaran/v_add_pengeluaran');
		$this->load->view('v_footer');
	}

	function insert(){
		$id_pengeluaran = $this->input->post('id_pengeluaran');
		$nama_pengeluaran = $this->input->post('nama_pengeluaran');
		$harga = $this->input->post('harga');
		$tanggal = $this->input->post('tanggal');
		$keterangan = $this->input->post('keterangan');

		$data = array(
			'id_pengeluaran' => $id_pengeluaran,
			'nama_pengeluaran' => $nama_pengeluaran,
			'harga' => $harga,
			'tanggal' => $tanggal,
			'keterangan' => $keterangan,
		);

		$this->m_pengeluaran->insert_data($data);
		redirect('pengeluaran');
	}

	function edit($id){
		$data['title']= 'Ubah Data pengeluaran';

		$where = array('id_pengeluaran' => $id); 
		$data['r']= $this->m_pengeluaran->edit_data($where)->row_array();

		$this->load->view('v_header',$data);
		$this->load->view('pengeluaran/v_edit_pengeluaran', $data);
		$this->load->view('v_footer');
	}

	function update(){
		$id = $this->input->post('id_pengeluaran');
		$nama_pengeluaran = $this->input->post('nama_pengeluaran');
		$harga = $this->input->post('harga');
		$tanggal = $this->input->post('tanggal');
		$keterangan = $this->input->post('keterangan');

		$data = array(
			'nama_pengeluaran' => $nama_pengeluaran,
			'harga' => $harga,
			'tanggal' => $tanggal,
			'keterangan' => $keterangan
		);

		$where = array('id_pengeluaran' => $id);
		$this->m_pengeluaran->update_data($data, $where);

		redirect('pengeluaran');
	}

	function hapus($id){
		$where = array('id_pengeluaran' => $id);
		$this->m_pengeluaran->hapus_data($where);
		redirect('pengeluaran');
	}
}
