<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class pembayaran extends CI_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('M_pembayaran');
	}

	public function index()
	{
		$data['title']= 'Manajemen Data pembayaran';
		$data['pembayaran']= $this->M_pembayaran->tampil_data()->result_array();

		$this->load->view('v_header',$data);
		$this->load->view('pembayaran/v_data_pembayaran', $data);
		$this->load->view('v_footer');
	}
	
	function tambah(){
		$data['title']= 'Tambah Data pembayaran';

		$this->load->view('v_header',$data);
		$this->load->view('pembayaran/v_add_pembayaran');
		$this->load->view('v_footer');
	}

	function insert(){
		$id_pembayaran = $this->input->post('id_pembayaran');
		$metode_pembayaran = $this->input->post('metode_pembayaran');
		$status = $this->input->post('status');

		$data = array(
			'id_pembayaran' => $id_pembayaran,
			'metode_pembayaran' => $metode_pembayaran,
			'status' => $status,
		);

		$this->m_pembayaran->insert_data($data);
		redirect('pembayaran');
	}

	function edit($id){
		$data['title']= 'Ubah Data pembayaran';

		$where = array('id_pembayaran' => $id);
		$data['r']= $this->m_pembayaran->edit_data($where)->row_array();

		$this->load->view('v_header',$data);
		$this->load->view('pembayaran/v_edit_pembayaran', $data);
		$this->load->view('v_footer');
	}

	function update(){
		$id = $this->input->post('id');
		$id_pembayaran = $this->input->post('id_pembayaran');
		$metode_pembayaran = $this->input->post('metode_pembayaran');
		$status = $this->input->post('status');

		$data = array(
			'id_pembayaran' => $id_pembayaran,
			'metode_pembayaran' => $metode_pembayaran,
			'status' => $status,
		);

		$where = array('id_pembayaran' => $id);
		$this->m_pembayaran->update_data($data, $where);

		redirect('pembayaran');
	}

	function hapus($id){
		$where = array('id_pembayaran' => $id);
		$this->m_pembayaran->hapus_data($where);
		redirect('pembayaran');
	}

}
