<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class paket_laundry extends CI_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('M_paket_laundry');
	}

	public function index()
	{
		$data['title']= 'Manajemen Data paket_laundry';
		$data['paket_laundry']= $this->M_paket_laundry->tampil_data()->result_array();

		$this->load->view('v_header',$data);
		$this->load->view('paket_laundry/v_data_paket_laundry', $data);
		$this->load->view('v_footer');
	}
	
	function tambah(){
		$data['title']= 'Tambah Data paket_laundry';

		$this->load->view('v_header',$data);
		$this->load->view('paket_laundry/v_add_paket_laundry');
		$this->load->view('v_footer');
	}

	function insert(){
		$id_paket = $this->input->post('id_paket');
		$nama_paket = $this->input->post('nama_paket');
		$harga_perkg = $this->input->post('harga_perkg');
		$estimasi_selesai = $this->input->post('estimasi_selesai');

		$data = array(
			'id_paket' => $id_paket,
			'nama_paket' => $nama_paket,
			'harga_perkg' => $harga_perkg,
			'estimasi_selesai' => $estimasi_selesai,
		);

		$this->m_paket_laundry->insert_data($data);
		redirect('paket_laundry');
	}

	function edit($id){
		$data['title']= 'Ubah Data paket_laundry';

		$where = array('id_paket' => $id);
		$data['r']= $this->m_paket_laundry->edit_data($where)->row_array();

		$this->load->view('v_header',$data);
		$this->load->view('paket_laundry/v_edit_paket_laundry', $data);
		$this->load->view('v_footer');
	}

	function update(){
		$id = $this->input->post('id_paket');
		$nama_paket = $this->input->post('nama_paket');
		$harga_perkg = $this->input->post('harga_perkg');
		$estimasi_selesai = $this->input->post('estimasi_selesai');

		$data = array(
			'id_paket' => $id_paket,
			'nama_paket' => $nama_paket,
			'harga_perkg' => $harga_perkg,
			'estimasi_selesai' => $estimasi_selesai,
		);

		$where = array('id_paket' => $id);
		$this->m_paket_laundry->update_data($data, $where);

		redirect('paket_laundry');
	}

	function hapus($id){
		$where = array('id_paket' => $id);
		$this->m_paket_laundry->hapus_data($where);
		redirect('paket_laundry');
	}

}
